% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ALTopt.R
\name{compare.vdus}
\alias{compare.vdus}
\title{Comparing designs using VDUS}
\usage{
compare.vdus(...)
}
\arguments{
\item{...}{Objects created by \code{\link{pv.vdus.rc}} or
\code{\link{pv.vdus.ic}}.}
}
\value{
VDUS plots of multiple designs.
}
\description{
\code{\link{compare.vdus}} draws the VDUS plots of multiple designs on a
single frame.
}
\examples{
\dontrun{
# Generating D optimal design and VDUS plot.
Dopt <- altopt.rc("D", 100, 100, 2, 1, formula = ~ x1 + x2 + x1:x2,
coef = c(0, -4.086, -1.476, 0.01))

VDUS.D <- pv.vdus.rc(Dopt$opt.design.rounded, 100, 2, 1,
formula = ~ x1 + x2 + x1:x2, coef = c(0, -4.086, -1.476, 0.01),
useLower = c(1.458, 2.859), useUpper = c(2.058, 3.459))

# Generating U optimal design and VDUS plot.
Uopt <- altopt.rc("U", 100, 100, 2, 1, formula = ~ x1 + x2 + x1:x2,
coef = c(0, -4.086, -1.476, 0.01), useCond = c(1.758, 3.159))

VDUS.U <- pv.vdus.rc(Uopt$opt.design.rounded, 100, 2, 1,
formula = ~ x1 + x2 + x1:x2, coef = c(0, -4.086, -1.476, 0.01),
useLower = c(1.458, 2.859), useUpper = c(2.058, 3.459))

# Comparing D and U optimal designs.
compare.vdus(VDUS.D, VDUS.U)
}
}
\seealso{
\code{\link{pv.vdus.rc}}, \code{\link{pv.vdus.ic}}
}

