% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_fun.R
\name{ACSS_gs}
\alias{ACSS_gs}
\title{ACSS algorithm}
\usage{
ACSS_gs(
  Y,
  X,
  a = 1,
  b = 1,
  c = 1,
  s,
  Max_burnin = 10,
  nmc = 5000,
  adaptive_burn_in = TRUE
)
}
\arguments{
\item{Y}{A vector.}

\item{X}{A matrix.}

\item{a}{shape parameter for marginal of q; default=1.}

\item{b}{shape parameter for marginal of q; default=1.}

\item{c}{shape parameter for marginal of lambda^2; larger c introduce more shrinkage and stronger correlation. default=1.}

\item{s}{scale (inversed) parameter for marginal of lambda^2; larger s introduce more shrinkage; default=sqrt(p).}

\item{Max_burnin}{Maximum burn-in (in 100 steps) for adaptive burn-in Gibbs sampler. Minimum value is 10, corresponding to 1000 hard burn-insteps. Default=10.}

\item{nmc}{Number of MCMC samples. Default=5000.}

\item{adaptive_burn_in}{Logical. If TRUE, use adaptive burn-in Gibbs sampler; If false, use fixed burn-in with burn-in = Max_burnin. Default=TRUE.}
}
\value{
A list with betahat: predicted beta hat from majority voting, and Gibbs_res: 5000 samples of beta, q and lambda^2 from Gibbs sampler.
}
\description{
Adaptive Correlated  Spike and Slab (ACSS) algorithm with/without adaptive burn-in Gibbs sampler. See paper of Yang, Z., Khare, K., & Michailidis, G. (2024) for details.
}
\examples{
## A toy example is given below to save time. The full example can be run to get better results
## by using X instead of X[, 1:30] and let nmc=5000 (default).

n = 30;
p = 2 * n;

beta1 = rep(0.1, p);
beta2 = c(rep(0.2, p / 2), rep(0, p / 2));
beta3 = c(rep(0.15, 3 * p / 4), rep(0, ceiling(p / 4)));
beta4 = c(rep(1, p / 4), rep(0, ceiling(3 * p / 4)));
beta5 = c(rep(3, ceiling(p / 20)), rep(0 , 19 * p / 20));
betas = list(beta1, beta3, beta2, beta4, beta5);

set.seed(123);
X = matrix(rnorm(n * p), n, p);
Y = c(X \%*\% betas[[1]] + rnorm(n));

## A toy example with p=30, total Gibbs steps=1100, takes ~0.6s
system.time({mod = ACSS_gs(Y, X[, 1:30], 1, 1, 1, sqrt(p), nmc = 100);})

mod$beta; ## estimated beta after the Majority voting
hist(mod$Gibbs_res$betamat[1,]); ## histogram of the beta_1
hist(mod$Gibbs_res$q); ## histogram of the q
hist(log(mod$Gibbs_res$lambdasq)); ## histogram of the log(lambda^2)
plot(mod$Gibbs_res$q); ## trace plot of the q
## joint posterior of model density and shrinkage
plot(log(mod$Gibbs_res$q / (1 - mod$Gibbs_res$q)), -log(mod$Gibbs_res$lambdasq),
    xlab = "logit(q)", ylab = "-log(lambda^2)",
    main = "Joint Posterior of Model Density and Shrinkage"); 
}
