% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SidakTest.R
\name{SidakTest}
\alias{SidakTest}
\title{Sidak Test for Multiple Comparisons v2.0}
\usage{
SidakTest(modelo, comparar = NULL, alpha = 0.05)
}
\arguments{
\item{modelo}{An \code{aov} or \code{lm} object (full model: includes blocks, factors, etc.).}

\item{comparar}{Character vector with the name(s) of the factor(s) to compare:
- One name: main effect (e.g., "treatment" or "A")
- Several names: interaction (e.g., \code{c("A","B")} for \code{A:B})
If omitted, it uses the first factor in \code{modelo$xlevels}.}

\item{alpha}{Significance level (default 0.05).}
}
\value{
An object of class \code{"sidak"} and \code{"comparaciones"} containing:
\itemize{
  \item \code{Resultados}: a data.frame with columns \code{Comparacion}, \code{Diferencia}, \code{SE}, \code{t_value},
        \code{p_value} (unadjusted), \code{p_ajustada} (Sidak), \code{Valor_Critico} (critical difference), and \code{Significancia}.
  \item \code{Promedios}: a named vector of group means as defined by \code{comparar}.
  \item \code{Orden_Medias}: group names ordered from highest to lowest mean.
  \item \code{Metodo}: "Sidak-adjusted t-test".
  \item \code{Termino}: the term being compared (e.g., "A", "B", or "A:B").
  \item \code{MSerror}, \code{df_error}, \code{N}: useful for plots with error bars.
}
}
\description{
Performs pairwise comparisons using the Sidak correction to adjust p-values
and control the family-wise error rate in multiple testing scenarios. This method
assumes independence between comparisons and is slightly less conservative than Bonferroni.
}
\details{
The Sidak procedure adjusts the significance level to maintain an overall alpha
across all pairwise tests, providing an effective post hoc tool following ANOVA
or similar global tests.

Advantages:
- Controls the family-wise error rate under independence assumption.
- Slightly more powerful than Bonferroni.
- Simple to compute and interpret.

Disadvantages:
- Assumes independence of tests (may not hold in correlated data).
- Less robust when variances are unequal or data are non-normal.
}
\examples{
data(d_e, package = "Analitica")
mod <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- SidakTest(mod)
summary(resultado)
plot(resultado)

# RCBD
mod <- aov(Sueldo_actual ~ as.factor(labor) + Sexo, data = d_e)
res <- SidakTest(mod, comparar = "as.factor(labor)")
summary(res); plot(res)                      # plot usara p_value

# Factorial
mod2 <- aov(Sueldo_actual ~ as.factor(labor) * Sexo, data = d_e)
resAB <- SidakTest(mod2, comparar = c("as.factor(labor)","Sexo"))
summary(resAB, n = Inf); plot(resAB, horizontal = TRUE)

}
\references{
Sidak, Z. (1967). "Rectangular confidence regions for the means of multivariate normal distributions." \emph{Journal of the American Statistical Association}, 62(318), 626–633.
}
