% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SECrule.R
\name{SECrule}
\alias{SECrule}
\title{Sequential equal contributions rule}
\usage{
SECrule(c)
}
\arguments{
\item{c}{A numeric cost vector.}
}
\value{
A numeric contribution vector, where each element represents the payment of the different agents.
}
\description{
\code{SECrule} calculates the contribution vector selected by the SEC rule.
}
\details{
For each \eqn{c\in C^N} and each \eqn{i\in N}, the sequential equal contributions rule is defined by
\deqn{
\text{SEC}_i=\frac{c_1}{n}+\frac{c_2-c_1}{n-1}+\dots+\frac{c_i-c_{i-1}}{n-i+1}
}
This rule is based on applying an equal division to each segment separately,
so that all agents using a given segment contribute equally to its cost. Each agent's contribution is then obtained as a sum of terms,
one for each of the segments they use.

The contribution selected by the SEC rule for a problem \eqn{c \in C^N} coincides with the payoff vector assigned
by the Shapley value to the associated cost game \eqn{v\in G^N}, that is, \eqn{\text{SEC}(c)=\text{Sh}(v)}.
}
\examples{
c <- c(1, 3, 7, 10) # Cost vector
SECrule(c)

}
\references{
Chun, Y., Hu, C.-C., and Yeh, C. (2012). Characterizations of the sequential equal contributions rule for the
airport problem. \emph{International Journal of Economic Theory}, 8, 77-85.

Littlechild, S.C. and Owen, G. (1973). A simple expression for the Shapley value in a special case.
\emph{Management Science}, 20, 370-372.

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{basicrule}}, \code{\link{weightedrule}}, \code{\link{clonesrule}}, \code{\link{hierarchicalrule}}
}
