% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms.R
\name{grid_search_check}
\alias{grid_search_check}
\title{Check the time consumed by running the grid search algorithm with a zoom.}
\usage{
grid_search_check(FUN, grid, MoreArgs = NULL, zoom = 0, decay = 0.5,
  num = 1, parallel = FALSE, cores = NULL, silent = TRUE)
}
\arguments{
\item{FUN}{the target function to be minimized.}

\item{grid}{an object of the class GRID from \code{\link{build_grid}}.}

\item{MoreArgs}{a list of other arguments to \code{FUN}, see \code{\link{mapply}}.}

\item{zoom}{number of (additional) rounds or layers of the zoom-in, 0 by default.}

\item{decay}{a number in between 0 and 1 representing the decay rate of the grid sizes of the zoom.}

\item{num}{number of points to return, i.e. the smallest \code{num} points, 1 by default the minimum.}

\item{parallel}{a boolean indicating if the parallel computation is carried out, by default \code{FALSE}.}

\item{cores}{The number of cores to use, i.e. at most how many child processes will be run simultaneously. For details, see \code{mcmapply} in \code{parallel} package.}

\item{silent}{a boolean indicating if the information regarding the computation is printed.}
}
\value{
a number of the time in seconds.
}
\description{
This function checks the time consumed by running the grid search algorithm with a zoom as well as some other conditions.
}
\details{
The running of this function takes only several seconds.
So it is recommended to run this function before \code{\link{grid_search}} to check the approximate time consumed
by \code{\link{grid_search}} by using exactly the same arguments.

This function is extremely useful when the user is going to run \code{\link{grid_search}} on some super-computing server
and need to know approximately how long time it will take in order to specify the corresponding settings
according to some batch system like SLURM for example.

The boolean \code{silent} controls if there will be output in the console.

For details, see \code{\link{grid_search}}.
}
\examples{
# Rastrigin function
ndim = 2 # number of dimension
nA = 10 # parameter A
# vx in [-5.12, 5.12]

# minimizer = rep(0, ndim)
# minimum = 0
Rastrigin <- function(vx) return(nA * ndim + sum(vx*vx - nA * cos(2*pi*vx)))

# a toy example
# build the grid first
bin = c(from=-5.12, to=5.12, by=.5)
grid = build_grid(bin,bin)
# so this is a relatively sparse grid

# serial computation
ret0 = grid_search(Rastrigin, grid, silent=FALSE)
ret0$par

\donttest{
# If we expand the grid to allow for more points
bin = c(from=-5.12, to=5.12, by=.1)
grid = build_grid(bin,bin)

# run the check before the grid search
ret1 = grid_search_check(Rastrigin, grid, silent=FALSE)
ret1 = grid_search(Rastrigin, grid, silent=FALSE)
}

}
\seealso{
\code{\link{build_grid}}, \code{\link{grid_search}}
}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{algorithms}
