% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_bookdown.R
\name{gitbook_config}
\alias{gitbook_config}
\title{Configure \code{bookdown::gitbook()} output}
\usage{
gitbook_config(
  toc_collapse = yml_blank(),
  toc_scroll_highlight = yml_blank(),
  toc_before = yml_blank(),
  toc_after = yml_blank(),
  toolbar_position = yml_blank(),
  edit = yml_blank(),
  download = yml_blank(),
  search = yml_blank(),
  fontsettings_theme = yml_blank(),
  fontsettings_family = yml_blank(),
  fontsettings_size = yml_blank(),
  sharing_facebook = yml_blank(),
  sharing_twitter = yml_blank(),
  sharing_google = yml_blank(),
  sharing_linkedin = yml_blank(),
  sharing_weibo = yml_blank(),
  sharing_instapaper = yml_blank(),
  sharing_vk = yml_blank(),
  sharing_all = yml_blank(),
  ...
)
}
\arguments{
\item{toc_collapse}{Collapse some items initially when a page is loaded via
the collapse option. Its possible values are "subsection" (the default),
"section", "none", or \code{NULL}.}

\item{toc_scroll_highlight}{Logical. Enable highlighting of TOC items as you
scroll the book body? The default is \code{TRUE}.}

\item{toc_before, toc_after}{a character vector of HTML to add more items
before and after the TOC using the HTML tag \verb{<li>}. These items will be
separated from the TOC using a horizontal divider.}

\item{toolbar_position}{The toolbar position: "fixed" or "static." The
default ("fixed") is that the toolbar will be fixed at the top of the page,
whereas when set to "static" the toolbar will not scroll with the page.}

\item{edit}{If not empty, an edit button will be added to the toolbar.}

\item{download}{This option takes either a character vector or a list of
character vectors with the length of each vector being 2. When it is a
character vector, it should be either a vector of filenames or filename
extensions. When you only provide the filename extensions, the filename is
derived from the book filename of the configuration file \verb{_bookdown.yml}}

\item{search}{Include a search bar?}

\item{fontsettings_theme}{The theme. "White" (the default), "Sepia", or
"Night".}

\item{fontsettings_family}{The font family. "sans" (the default) or "serif".}

\item{fontsettings_size}{The font size. Default is 2.}

\item{sharing_facebook}{Logical. Include Facebook share link? Default is
\code{TRUE}.}

\item{sharing_twitter}{Logical. Include Twitter share link? Default is
\code{TRUE}.}

\item{sharing_google}{Logical. Include Google share link? Default is \code{FALSE}.}

\item{sharing_linkedin}{Logical. Include LinkedIn share link? Default is
\code{FALSE}.}

\item{sharing_weibo}{Logical. Include Weibo share link? Default is \code{FALSE}.}

\item{sharing_instapaper}{Logical. Include Instapaper share link? Default is
\code{FALSE}.}

\item{sharing_vk}{Logical. Include VK share link? Default is \code{FALSE}.}

\item{sharing_all}{Logical. Include all share links? Default is \code{FALSE}.}

\item{...}{additional named R objects, such as characters or lists, to
transform into YAML}
}
\value{
a list to use in the \code{config} argument of \code{\link[bookdown:gitbook]{bookdown::gitbook()}}
}
\description{
\code{gitbook_config()} is a helper function to specify the \code{config} argument in
\code{\link[bookdown:gitbook]{bookdown::gitbook()}}, as described in the \href{https://bookdown.org/yihui/bookdown/html.html}{bookdown book}.
}
\seealso{
Other bookdown: 
\code{\link{yml_bookdown_opts}()}
}
\concept{bookdown}
