% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reduce.R
\name{reduceexpand}
\alias{reduceexpand}
\alias{\%|.\%}
\alias{\%.|\%}
\title{Use function to reduce or expand arguments.}
\usage{
f \%|.\% args

args \%.|\% f
}
\arguments{
\item{f}{function.}

\item{args}{argument list or vector, entries expanded as function arguments.}
}
\value{
f(args) where args elements become individual arguments of f.
}
\description{
The operators \code{\%.|\%} and \code{\%|.\%} are wrappers for \code{\link[base]{do.call}}.
These functions are used to pass arguments from a list to variadic
function (such as \code{\link[base]{sum}}). The operator symbols are meant to invoke non-tilted
versions of APL's reduce and expand operators. Unevaluated expressions containing
\code{\%.|\%}, \code{\%|.\%}, or \code{\link[base]{do.call}} can be used simulate partial function
application or simulate function Currying.  The take-away is one can delegate all
variadic argument construction to \code{\link[base]{list}}, and manipulation to \code{\link[base]{c}}.
}
\section{Functions}{
\itemize{
\item \code{\%|.\%}: f reduce args

\item \code{\%.|\%}: args expand f
}}

\examples{

# basic examples
1:10 \%.|\% sum
1:10 \%.|\% base::sum
1:10 \%.|\% function(...) { sum(...) }

# simulate partial application of log(., base=2)
1:4 \%.>\% do.call(log, list(., base = 2))

# # simluate partial application with dplyr
# # can be used with dplyr/rlang as follows
# d <- data.frame(x=1, y=2, z=3)
# syms <- rlang::syms(c("x", "y"))
# d \%.>\% do.call(dplyr::select, c(list(.), syms))

}
\seealso{
\code{\link[base]{do.call}}, \code{\link[base]{list}}, \code{\link[base]{c}}
}
