% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpipe.R
\name{dot_arrow}
\alias{dot_arrow}
\alias{\%.>\%}
\alias{\%>.\%}
\title{Pipe operator ("dot arrow").}
\usage{
pipe_left_arg \%.>\% pipe_right_arg

pipe_left_arg \%>.\% pipe_right_arg
}
\arguments{
\item{pipe_left_arg}{left argument expression (substituted into .)}

\item{pipe_right_arg}{right argument expession (presumably including .)}
}
\value{
eval(\{ . <- pipe_left_arg; pipe_right_arg \};)
}
\description{
Defined as roughly : \code{a \%>.\% b} ~ \code{\{ . <- a; b \};}
(with visible .-side effects).
}
\details{
The pipe operator has a couple of special cases. First: if the right hand side is a name,
then we try to de-reference it and apply it as a function or surrogate function.

The pipe operator checks for and throws an exception for a number of "pipled into
nothing cases" such as \code{5 \%.>\% sin()}, many of these checks can be turned
off by adding braces.

For some discussion, please see \url{http://www.win-vector.com/blog/2017/07/in-praise-of-syntactic-sugar/}.
For some more examples, please see the package README \url{https://github.com/WinVector/wrapr}.
For formal documentation please see \url{https://github.com/WinVector/wrapr/blob/master/extras/wrapr_pipe.pdf}.
\code{\%>.\%} and \code{\%.>\%} are synonyms.
}
\section{Functions}{
\itemize{
\item \code{\%.>\%}: dot arrow

\item \code{\%>.\%}: alias for dot arrow
}}

\examples{

# both should be equal:
cos(exp(sin(4)))
4 \%.>\% sin(.) \%.>\% exp(.) \%.>\% cos(.)

}
