% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFilePath.R
\name{.doubleExt}
\alias{.doubleExt}
\title{Return File-name Extensions Including Double Extensions (eg txt.gz)}
\usage{
.doubleExt(fiNa, termExt = c("gz", "zip"))
}
\arguments{
\item{fiNa}{(character) name of file to be tested (may include path)}

\item{termExt}{(character) additional terminal extensions}
}
\value{
This function returns a character vector with file-extensions (excluding the leading dot). (Only purely alphanumeric extensions are recognized.)
}
\description{
This function allows retreiving extensions to filenames similar to \code{\link[tools]{file_ext}}, but also alllows to retreive selected double-extensions (txt.gz).
The leading dor will ne excluded similar to \code{\link[tools]{file_ext}}
}
\details{
The argument \code{termExt} allows specifying additional (terminal) extensions to be recognized.
}
\examples{
fi <- c("ab","ab.c","ab.c.gz","ab.d","ab.d.zip","ab.e")
.doubleExt(fi)
}
\seealso{
\code{\link[tools]{file_ext}},  \code{\link{checkFilePath}}
}
