/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone;

import com.nexagis.jawbone.FrameData;
import com.nexagis.jawbone.LineSplitter;
import com.nexagis.jawbone.PartOfSpeech;
import com.nexagis.jawbone.Pointer;
import com.nexagis.jawbone.Synset;
import com.nexagis.jawbone.Utility;
import com.nexagis.jawbone.WordData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParseDataFile {
    private ParseDataFile() {
    }

    private static void writeErr(String string) {
        System.err.println(string);
    }

    protected static boolean process(String string, Synset synset) {
        String string2;
        int n;
        int n2;
        if (string == null || string.length() < 1 || string.charAt(0) == ' ') {
            return false;
        }
        if (synset == null) {
            return false;
        }
        LineSplitter lineSplitter = new LineSplitter(string, ' ');
        long l = Long.parseLong(lineSplitter.nextToken());
        synset.setSynsetOffset(l);
        int n3 = Integer.parseInt(lineSplitter.nextToken());
        synset.setLexFilenum(n3);
        synset.setPosType(lineSplitter.nextToken().charAt(0));
        int n4 = Integer.parseInt(lineSplitter.nextToken(), 16);
        synset.setNumWords(n4);
        for (n2 = 0; n2 < n4; ++n2) {
            int n5;
            String string3 = lineSplitter.nextToken().replace('_', ' ');
            int n6 = Integer.parseInt(lineSplitter.nextToken(), 16);
            String string4 = null;
            n = string3.length();
            if (synset.getPOS().equals(PartOfSpeech.ADJECTIVE) && n > 3 && string3.endsWith(")") && (n5 = string3.lastIndexOf(40)) >= 0 && n5 < n - 2) {
                string4 = string3.substring(n5 + 1, string3.length() - 1);
            }
            WordData wordData = new WordData(string3, n6, string4, synset.getPOS(), synset.getSynsetOffset());
            synset.addWord(wordData);
        }
        int n7 = Integer.parseInt(lineSplitter.nextToken());
        synset.setPointerCount(n7);
        for (n2 = 0; n2 < n7; ++n2) {
            String string5 = lineSplitter.nextToken();
            long l2 = Long.parseLong(lineSplitter.nextToken());
            char c = lineSplitter.nextToken().charAt(0);
            String string6 = lineSplitter.nextToken();
            int n8 = Integer.parseInt(string6.substring(0, 2), 16);
            int n9 = Integer.parseInt(string6.substring(2), 16);
            Pointer pointer = new Pointer(string5, l2, c, n8, n9);
            synset.addPointer(pointer);
        }
        if (synset.getPOS().equals(PartOfSpeech.VERB)) {
            int n10 = Integer.parseInt(lineSplitter.nextToken());
            synset.setFrameCount(n10);
            for (n2 = 0; n2 < n10; ++n2) {
                lineSplitter.nextToken();
                int n11 = Integer.parseInt(lineSplitter.nextToken());
                n = Integer.parseInt(lineSplitter.nextToken(), 16);
                FrameData frameData = new FrameData(n11, n);
                synset.addFrame(frameData);
            }
        }
        if ((string2 = lineSplitter.nextToken()).equals("|")) {
            synset.setGloss(lineSplitter.restOfString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<Synset> parseFile(PartOfSpeech partOfSpeech) {
        if (partOfSpeech == null) {
            return null;
        }
        String string = Utility.getFilename(partOfSpeech, false);
        if (string == null || string.length() < 1) {
            return null;
        }
        File file = new File(string);
        boolean bl = file.exists();
        if (!bl) {
            return null;
        }
        if (!file.isFile()) {
            return null;
        }
        ArrayList<Synset> arrayList = new ArrayList<Synset>(500);
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                Synset synset;
                if (string2.length() < 1 || string2.charAt(0) == ' ' || !ParseDataFile.process(string2, synset = new Synset())) continue;
                arrayList.add(synset);
            }
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            ParseDataFile.writeErr("File Not Found: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            ParseDataFile.writeErr("Exception reading: " + iOException.getMessage());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    bufferedReader = null;
                }
                catch (Exception exception) {
                    bufferedReader = null;
                }
            }
        }
        return arrayList;
    }
}

