% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataParse.R
\name{qualtrics.rune}
\alias{qualtrics.rune}
\title{Parse composite Qualtrics survey into component data frames by variable prefix}
\usage{
qualtrics.rune(
  qualtrics_alias,
  institution = NULL,
  label = FALSE,
  interview_date = NULL,
  lower = TRUE
)
}
\arguments{
\item{qualtrics_alias}{Character string specifying the Qualtrics survey alias to retrieve.}

\item{institution}{Character string; default NULL, specify location}

\item{label}{Logical; default TRUE, returns coded values as labels instead of raw values.}

\item{interview_date}{Logical or Date String, returns all data before date}

\item{lower}{default TRUE convert prefixes to lower case}
}
\value{
Creates multiple dataframes in the global environment, one for each survey
detected in the data. Each dataframe is named after its survey prefix.
}
\description{
This function fetches a Qualtrics data frame containing multiple surveys and
separates it into individual data frames for each survey detected in the data.
It identifies the appropriate identifier column (e.g., participantId, workerId)
and splits the data based on column name prefixes.
}
\details{
The function performs the following steps:
\itemize{
\item Retrieves the raw Qualtrics data using the getSurvey() function
\item Identifies which identifier column to use (participantId, workerId, PROLIFIC_PID, or src_subject_id)
\item Determines survey prefixes by analyzing column names
\item Creates separate dataframes for each survey prefix found
\item Assigns each dataframe to the global environment with names matching the survey prefixes
}
}
\examples{
\dontrun{
# Parse a Qualtrics export containing multiple surveys
qualtrics.rune("combined_surveys", label = FALSE)

# After running, access individual survey dataframes directly:
head(pss)  # Access the PSS survey dataframe
head(cesd) # Access the CESD survey dataframe
}

}
