% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_csv.R
\name{download_csv}
\alias{download_csv}
\title{Download the csv-file of a table}
\usage{
download_csv(
  tablename,
  startyear = "",
  endyear = "",
  ...,
  genesis_db = "de",
  save = TRUE
)
}
\arguments{
\item{tablename}{name of the table to retrieve.}

\item{startyear}{only retrieve values for years equal or larger to \code{startyear}. Default: "".}

\item{endyear}{only retrieve values for years smaller or equal to \code{endyear}. Default: "".}

\item{...}{further parameters supplied as URL parameter in the GENESIS database call}

\item{genesis_db}{name of the database (default: 'de').}

\item{save}{write string to a text file (default: TRUE)}
}
\description{
\code{download_csv()} downloads the csv for a table
}
\details{
Downloads the csv file either to the working directory \code{getwd()} or outputs it as a string. 
This is an alternative approach to the retrieve_*() functions. This is designed for \url{https://www-genesis.destatis.de/genesis/online} as it does not require a login. It might not work as expected for the other databases.
}
\examples{
 \dontrun{

 download_csv("12411-0004.csv")

 }




}
\seealso{
\code{\link{read_header_genesis}}.
}
