% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{shrink}
\alias{shrink}
\title{Shrink file size of a PNG}
\usage{
shrink(filename)
}
\arguments{
\item{filename}{Character vector containing the path of images to resize.
Must be PNG files.}
}
\value{
The `filename` supplied but with a class value of `"webshot"`.
}
\description{
This does not change size of the image in pixels, nor does it affect
appearance -- it is lossless compression. This requires the program
\code{optipng} to be installed.
}
\details{
If other operations like resizing are performed, shrinking should occur as
the last step. Otherwise, if the resizing happens after file shrinking, it
will be as if the shrinking didn't happen at all.
}
\examples{
if (interactive()) {
  webshot("https://www.r-project.org/", "r-shrink.png") \%>\%
    shrink()
}
}
