% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/means.between.cpt.R
\name{means.between.cpt}
\alias{means.between.cpt}
\title{Means between change-points}
\usage{
means.between.cpt(x, cpt = NULL, ...)
}
\arguments{
\item{x}{a vector}

\item{cpt}{a vector of integers with localisations of change-points}

\item{...}{further arguments passed to \code{mean} method}
}
\value{
a vector of the same length as \code{x}, piecewise constant and equal to the mean between change-points given in \code{cpt}
}
\description{
The function finds the average of the input vector \code{x} between change-points given in \code{cpt}.
}
\examples{
x <- rnorm(100)+c(rep(-1,50),rep(1,50))
cpt <- 50
means.between.cpt(x,cpt)
w <- wbs(x)
cpt <- changepoints(w)
means.between.cpt(x,cpt=cpt$cpt.ic$sbic)
}
