% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{package}
\name{wbs-package}
\alias{wbs-package}
\title{Wild Binary Segmentation for multiple change-point detection}
\description{
The package implements Wild Binary Segmentation, a technique for
consistent estimation of  the number and locations of multiple change-points in data.
It also provides a fast implementation of the standard Binary Segmentation algorithm.
}
\details{
The main routines of the package are \code{\link{wbs}}, \code{\link{sbs}} and \code{\link{changepoints}}.
}
\examples{
#an example in which standard Binary Segmentation fails to detect change points
x <- rnorm(300)+ c(rep(0,130),rep(-1,20),rep(1,20),rep(0,130))

s <- sbs(x)
w <- wbs(x)

s.cpt <- changepoints(s)
s.cpt

w.cpt <- changepoints(w)
w.cpt
# in this example, both algorithms work well
x <- rnorm(300) + c(rep(1,50),rep(0,250))

s <- sbs(x)
w <- wbs(x)

s.cpt <- changepoints(s)
s.cpt

w.cpt <- changepoints(w)
w.cpt
}
\references{
P. Fryzlewicz (2014), Wild Binary Segmentation for multiple change-point detection. Annals of Statistics, to appear. (\url{http://stats.lse.ac.uk/fryzlewicz/wbs/wbs.pdf})
}
\keyword{math}
\keyword{models}
\keyword{ts}

