% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importDVs.R
\name{plotParam}
\alias{plotParam}
\title{Plot Streamflow and Continous Water-Quality Data}
\usage{
plotParam(data, logscale = FALSE, metric = FALSE, ylabel = NULL, ...)
}
\arguments{
\item{data}{is the data frame in the format of that returned by 
\link{importDVs}.}

\item{logscale}{is a logical indicating whether or not the y-scale should be 
log 10.  Streamflow generally is plotted with a log scale and this only has 
an effect on the plotting of streamflow data.}

\item{metric}{USGS streamflow data are usually in cubic feet per second;
however it may be converted to cubic meters per second for publication.  
Likewise, gage height is usually in feet, but could be converted to 
meters.  The metric argument only has an effect on streamflow and gage 
height.}

\item{ylabel}{optionally allows user to pass a y-axis label.}

\item{...}{further arguments to be passed to plotting method (see \link{par}). 
(see \link{xyplot}).}
}
\value{
a lattice plot
}
\description{
Function to plot hydrologic times series.  
Will plot more than one site at a time.
}
\examples{
data(exampleWaterData)
plotParam(misQ05054000, code="00060", stat="00003", logscale=TRUE)
plotParam(misQ05054000, code=attributes(misQ05054000)$code, 
stat=attributes(misQ05054000)$stat, logscale=TRUE)
}
\keyword{hplot}
\keyword{ts}
\keyword{univar}

