% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult_class.R
\name{prepare.multinomial_plan}
\alias{prepare.multinomial_plan}
\title{Function to apply mkCrossFrameMExperiment treatemnts.}
\usage{
\method{prepare}{multinomial_plan}(
  treatmentplan,
  dframe,
  ...,
  pruneSig = NULL,
  scale = FALSE,
  doCollar = FALSE,
  varRestriction = NULL,
  codeRestriction = NULL,
  trackedValues = NULL,
  extracols = NULL,
  parallelCluster = NULL,
  use_parallel = TRUE,
  check_for_duplicate_frames = TRUE
)
}
\arguments{
\item{treatmentplan}{multinomial_plan from mkCrossFrameMExperiment.}

\item{dframe}{new data to process.}

\item{...}{not used, declared to forced named binding of later arguments}

\item{pruneSig}{suppress variables with significance above this level}

\item{scale}{optional if TRUE replace numeric variables with single variable model regressions ("move to outcome-scale").  These have mean zero and (for variables with significant less than 1) slope 1 when regressed  (lm for regression problems/glm for classification problems) against outcome.}

\item{doCollar}{optional if TRUE collar numeric variables by cutting off after a tail-probability specified by collarProb during treatment design.}

\item{varRestriction}{optional list of treated variable names to restrict to}

\item{codeRestriction}{optional list of treated variable codes to restrict to}

\item{trackedValues}{optional named list mapping variables to know values, allows warnings upon novel level appearances (see \code{\link{track_values}})}

\item{extracols}{extra columns to copy.}

\item{parallelCluster}{(optional) a cluster object created by package parallel or package snow.}

\item{use_parallel}{logical, if TRUE use parallel methods.}

\item{check_for_duplicate_frames}{logical, if TRUE check if we called prepare on same data.frame as design step.}
}
\value{
prepared data frame.
}
\description{
Please see \code{vignette("MultiClassVtreat", package = "vtreat")} \url{https://winvector.github.io/vtreat/articles/MultiClassVtreat.html}.
}
\seealso{
\code{\link{mkCrossFrameMExperiment}}, \code{\link{prepare}}
}
