% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vst_dct_fcts.R
\name{Data.trafo}
\alias{Data.trafo}
\title{Data Transformation}
\usage{
Data.trafo(y, Te, dct.out = FALSE)
}
\arguments{
\item{y}{\code{nxp} dimensional data matrix}

\item{Te}{number of bins for data binning.  \code{Te} should be smaller than the vector length \code{p}.}

\item{dct.out}{logical. If \code{TRUE}, the \code{p}-dim. DCT-I matrix is returned. The default is \code{FALSE}.}
}
\value{
A list containing the following elements:
\itemize{
\item{\code{m}:  }{number of data points per bin, that is \code{m=n*round(p/Te)}. If \code{p/Te} is not an integer, the first/last bin may contain more than \code{m} data points.}
\item{\code{y.star}:   }{\code{2Te-2} dimensional vector with binned, variance stabilized and mirrowed data. The bin number \code{Te} may be modified to guarantee at least two data points per bin. If \code{p/Te} is not an integer, the vector dimension is \code{2*floor(p/round(p/Te))-2}.}
\item{\code{dct.matrix}: }{\code{p}-dim. DCT-I matrix (if \code{dct.out}=TRUE)}
}
}
\description{
Applies the Discrete Cosine I transform, data binning and the variance stabilizing transform function to the data.
}
