% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vol2birdR.R
\docType{package}
\name{vol2birdR-package}
\alias{vol2birdR}
\alias{vol2birdR-package}
\title{vol2birdR: Vertical Profiles of Biological Signals in Weather Radar Data}
\description{
'R' implementation of the 'vol2bird' software for generating vertical profiles of birds and other biological signals in weather radar data. See Dokter et al. (2011) \doi{10.1098/rsif.2010.0116} for a paper describing the methodology.
}
\details{
To get started, see:

\itemize{
\item Dokter et al. (2016) \doi{https://doi.org/10.1098/rsif.2010.0116}: a
paper describing the profiling algorithm.
\item \href{https://adriaandokter.com/vol2bird/}{'vol2bird' 'C' code documentation}:
an overview of the algorithm structure.
\item Lin T-Y et al. (2019) \doi{https://doi.org/10.1111/2041-210X.13280}: a
paper describing the 'MistNet' model for rain segmentation.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/adokter/vol2birdR/}
  \item \url{https://adriaandokter.com/vol2bird/}
  \item Report bugs at \url{https://github.com/adokter/vol2birdR/issues}
}

}
\author{
\strong{Maintainer}: Adriaan M. Dokter \email{vol2birdr@cornell.edu} (\href{https://orcid.org/0000-0001-6573-066X}{ORCID})

Authors:
\itemize{
  \item Anders Henja \email{anders.henja@gmail.com} (vol2birdR package author and author of RAVE and HLHDF libraries)
}

Other contributors:
\itemize{
  \item Alexander Tedeschi \email{at744@cornell.edu} (\href{https://orcid.org/0000-0003-0772-6931}{ORCID}) [contributor]
  \item Tsung-Yu Lin (contributor MistNet segmentation model) [contributor]
  \item Subranshu Maji \email{smaji@cs.umass.edu} (contributor MistNet segmentation model) [contributor]
  \item Daniel Sheldon \email{sheldon@cs.umass.edu} (contributor MistNet segmentation model) [contributor]
  \item Bart Kranstauber \email{b.kranstauber@uva.nl} (\href{https://orcid.org/0000-0001-8303-780X}{ORCID}) [contributor]
  \item Jurriaan H. Spaaks (contributor to vol2bird library) [contributor]
  \item Lourens Veen (contributor to vol2bird library) [contributor]
  \item Iwan Holleman (contributor to vol2bird library) [contributor]
  \item Hidde Leijnse (contributor to vol2bird library) [contributor]
  \item John H. Merritt (author of RSL library) [contributor, copyright holder]
  \item Bart Kelley (contributor and maintainer of RSL library) [contributor]
  \item Mark Couture (author of iris2odim add-on to RAVE library) [contributor]
  \item Daniel Falbel (contributor of original idea for building with torch support) [contributor]
  \item Swedish Meteorological and Hydrological Institute, SMHI (copyright holder of HLHDF and RAVE libraries) [copyright holder]
  \item GloBAM (https://globam.science) [funder]
}

}
\keyword{internal}
