% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Surv_CNSR.R
\name{Surv_CNSR}
\alias{Surv_CNSR}
\title{Create a Survival Object from CDISC Data}
\usage{
Surv_CNSR(AVAL, CNSR)
}
\arguments{
\item{AVAL}{The follow-up time. The follow-up time is assumed to originate from zero.
When no argument is passed, the default value is a column/vector named \code{AVAL}.}

\item{CNSR}{The censoring indicator where \code{1=censored} and \code{0=death/event}.
When no argument is passed, the default value is a column/vector named \code{CNSR}.}
}
\value{
Object of class 'Surv'
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The aim of \code{Surv_CNSR()} is to map the inconsistency in convention between
the \href{https://cran.r-project.org/package=survival}{survival} package and
\href{https://www.cdisc.org/standards/foundational/adam/adam-basic-data-structure-bds-time-event-tte-analyses-v1-0}{CDISC ADaM ADTTE data model}.

The function creates a survival object (e.g. \code{survival::Surv()}) that
uses CDISC ADaM ADTTE coding conventions and converts the arguments to the
status/event variable convention used in the
\href{https://cran.r-project.org/package=survival}{survival} package.

The \code{AVAL} and \code{CNSR} arguments are passed to
\code{survival::Surv(time = AVAL, event = 1 - CNSR, type = "right", origin = 0)}.
}
\section{Details}{


The \code{Surv_CNSR()} function creates a survival object utilizing the
expected data structure in the CDISC ADaM ADTTE data model,
mapping the CDISC ADaM ADTTE coding conventions with the expected
status/event variable convention used in the survival package---specifically,
the coding convention used for the status/event indicator.
The survival package expects the status/event indicator in the
following format: \code{0=alive}, \code{1=dead}. Other accepted choices are
\code{TRUE}/\code{FALSE} (\code{TRUE = death}) or \code{1}/\code{2} (\code{2=death}).
A final but risky option is to omit the indicator variable, in which case
all subjects are assumed to have an event.

The CDISC ADaM ADTTE data model adopts a different coding convention for
the event/status indicator. Using this convention, the event/status variable
is named \code{'CNSR'} and uses the following coding: \code{censor = 1}, \code{status/event = 0}.
}

\examples{
# Use the `Surv_CNSR()` function with visR functions
adtte \%>\%
  visR::estimate_KM(formula = visR::Surv_CNSR() ~ SEX)

# Use the `Surv_CNSR()` function with functions from other packages as well
survival::survfit(visR::Surv_CNSR() ~ SEX, data = adtte)
survival::survreg(visR::Surv_CNSR() ~ SEX + AGE, data = adtte) \%>\%
  broom::tidy()
}
\seealso{
\code{\link[survival:Surv]{survival::Surv()}}, \code{\link[=estimate_KM]{estimate_KM()}}
}
