% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain_report.R
\name{domain_report}
\alias{domain_report}
\title{Get Domain Report}
\usage{
domain_report(domain = NULL, ...)
}
\arguments{
\item{domain}{domain name. String. Required.}

\item{\dots}{Additional arguments passed to \code{\link{virustotal2_GET}}.}
}
\value{
named list with the following possible items: 
\code{`BitDefender category`, undetected_referrer_samples, whois_timestamp,
detected_downloaded_samples, detected_referrer_samples, `Webutation domain info`, `Alexa category`, undetected_downloaded_samples,
resolutions, detected_communicating_samples, `Opera domain info`, `TrendMicro category`, categories, domain_siblings, 
`BitDefender domain info`, whois, `Alexa domain info`, response_code, verbose_msg, `Websense ThreatSeeker category`, subdomains,
`WOT domain info`, detected_urls, `Alexa rank`, undetected_communicating_samples, `Dr.Web category`, pcaps}
}
\description{
Retrieves report on a given domain, including passive DNS, urls detected by at least one url scanner. 
Gives category of the domain from bitdefender.
}
\examples{
\dontrun{

# Before calling the function, set the API key using set_key('api_key_here')
   
domain_report("http://www.google.com")
domain_report("http://www.goodsfwrfw.com") # Domain not found
}
}
\references{
\url{https://developers.virustotal.com/v2.0/reference}
}
\seealso{
\code{\link{set_key}} for setting the API key
}
