% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open-api-spec.R
\name{map_request_body}
\alias{map_request_body}
\title{Identify data types for each column in an input data prototype}
\usage{
map_request_body(ptype)
}
\arguments{
\item{ptype}{An input data prototype from a model}
}
\value{
A list to be used within \code{\link[plumber:pr_set_api_spec]{plumber::pr_set_api_spec()}}
}
\description{
The OpenAPI specification of a Plumber API created via \code{\link[plumber:pr]{plumber::pr()}} can
be modified via \code{\link[plumber:pr_set_api_spec]{plumber::pr_set_api_spec()}}, and this helper function will
identify data types of predictors and create a list to use in this
specification. These are \emph{not} R data types, but instead basic JSON data
types. For example, factors in R will be documented as strings in the
OpenAPI specification.
}
\details{
This is a developer-facing function, useful for supporting new model types.
It is called by \code{\link[=api_spec]{api_spec()}}.
}
\examples{
map_request_body(vctrs::vec_slice(chickwts, 0))

}
