% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_chem2.R
\name{emis_chem2}
\alias{emis_chem2}
\title{Aggregate emissions by lumped groups in chemical mechanism}
\usage{
emis_chem2(df, mech, nx, na.rm = FALSE)
}
\arguments{
\item{df}{data.frame with emissions including columns "id" and "pol".}

\item{mech}{Character, "CB4", "CB05", "S99", "S7","CS7", "S7T", "S11",
"S11D","S16C","S18B","RADM2", "RACM2","MOZT1"}

\item{nx}{Character, colnames for emissions data, for instance "V1", "V2"...}

\item{na.rm}{Logical, to remove lines with NA from group}
}
\value{
data.frame with lumped groups by chemical mechanism.
}
\description{
\code{\link{emis_chem2}} aggregates VOC emissions by chemical mechanism
and convert grams to mol.
}
\examples{
\dontrun{
# experimental
}
}
\references{
Carter, W. P. (2015). Development of a database for
chemical mechanism assignments for volatile organic emissions.
Journal of the Air & Waste Management Association, 65(10), 1171-1184.
}
\seealso{
\code{\link{speciate}}
}
