% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vein_notes.R
\name{vein_notes}
\alias{vein_notes}
\title{vein_notes for writting technical notes about the inventory}
\usage{
vein_notes(notes, yourname, file = "README",
  title = "Notes for this VEIN run", approach = "Top Down",
  traffic = "Your traffic information",
  composition = "Your traffic information",
  ef = "Your information about emission factors",
  cold_start = "Your information about cold starts",
  evaporative = "Your information about evaporative emission factors",
  standards = "Your information about standards",
  mileage = "Your information about mileage")
}
\arguments{
\item{notes}{Character; vector of notes.}

\item{yourname}{Character; Name of the inventor compiler.}

\item{file}{Character; Name of the file. The function will generate a file
with an extension '.txt'.}

\item{title}{Character; Title of this file. For instance: "Vehicular Emissions
Inventory of Region XX, Base year XX"}

\item{approach}{Character; vector of notes.}

\item{traffic}{Character; vector of notes.}

\item{composition}{Character; vector of notes.}

\item{ef}{Character; vector of notes.}

\item{cold_start}{Character; vector of notes.}

\item{evaporative}{Character; vector of notes.}

\item{standards}{Character; vector of notes.}

\item{mileage}{Character; vector of notes.}
}
\value{
Writes a text file.
}
\description{
\code{\link{vein_notes}} creates aa text file '.txt' for
writting technical notes about this emissions inventory
}
\examples{
{
(a <- tempfile())
vein_notes("notes",
           file = a)
readLines(paste0(a, '.txt'))
}
}
