% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_age.R
\name{my_age}
\alias{my_age}
\title{Returns amount of vehicles at each age}
\usage{
my_age(x, y, name = "veh", k = 1, net, message = TRUE)
}
\arguments{
\item{x}{Numeric; vehicles by street (or spatial feature).}

\item{y}{Numeric; vehicles by age of use}

\item{name}{of vehicle assigned to columns of dataframe.}

\item{k}{multiplication factor.}

\item{net}{SpatialLinesDataFrame or Spatial Feature of "LINESTRING"}

\item{message}{message with average age and total numer of vehicles.}
}
\value{
dataframe of age distrubution of vehicles.
}
\description{
\code{my_age} returns amount of vehicles at each age using a
numeric vector.
}
\examples{
{
data(net)
dpc <- c(seq(1,20,3), 20:10)
PC_E25_1400 <- my_age(x = net$ldv, y = dpc, name = "PC_E25_1400")
class(PC_E25_1400)
plot(PC_E25_1400)
PC_E25_1400sf <- my_age(x = net$ldv, y = dpc, name = "PC_E25_1400", net = net)
class(PC_E25_1400sf)
plot(PC_E25_1400sf)
PC_E25_1400nsf <- sf::st_set_geometry(PC_E25_1400sf, NULL)
class(PC_E25_1400nsf)
}
}
