% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_wrf.R
\name{emis_wrf}
\alias{emis_wrf}
\title{Generates emissions dataframe to generate WRF-Chem inputs}
\usage{
emis_wrf(sdf, nr = 1, dmyhm, tz, crs = 4326, islist, utc)
}
\arguments{
\item{sdf}{Gridded emissions, which can be a SpatialPolygonsDataFrame, or a list
of SpatialPolygonsDataFrame, or a sf object of "POLYGON". The user must enter
a list with 36 SpatialPolygonsDataFrame with emissions for the mechanism CBMZ.}

\item{nr}{Number of repetitions of the emissions period}

\item{dmyhm}{String indicating Day Month Year Hour and Minute in the format
"d-m-Y H:M" e.g.: "01-05-2014 00:00" It represents the time of the first
hour of emissions in Local Time}

\item{tz}{Time zone as required in for function \code{\link{as.POSIXct}}}

\item{crs}{Coordinate reference system, e.g: "+init=epsg:4326". Used to
transform the coordinates of the output}

\item{islist}{logical value to indicate if sdf is a list or not}

\item{utc}{ignored.}
}
\value{
data-frame of gridded emissions  (mass)/h. Remember convert to mol.
}
\description{
\code{emis_wrf} returns a dataframes with columns lat, long, id, pollutants, local time
and GMT time. This dataframe has the proper format to be used with WRF
assimilation system: "ASimilation System 4 WRF (AS4WRF Vera-Vala et al (2016))
}
\note{
The reference of the emissions assimilation system is Vara-Vela, A.,
Andrade, M. F., Kumar, P., Ynoue, R. Y., and Munoz, A. G.: Impact of
vehicular emissions on the formation of fine particles in the Sao Paulo
Metropolitan Area: a numerical study with the WRF-Chem model, Atmos. Chem.
Phys., 16, 777-797, doi:10.5194/acp-16-777-2016, 2016.
A good website with timezones is http://www.timezoneconverter.com/cgi-bin/tzc
The crs is the same as used by \code{\link{sp}} package
It returns a dataframe with id,, long, lat, pollutants, time_lt, time_utc
and day-UTC-hour (dutch)
The pollutants for the CBMZ are: e_so2, e_no, e_ald, e_hcho, e_ora2, e_nh3
e_hc3, e_hc5, e_hc8, e_eth, e_co, e_ol2, e_olt, e_oli, e_tol, e_xyl, e_ket
e_csl, e_iso, e_no2, e_ch3oh, e_c2h5oh, e_pm25i, e_pm25j, e_so4i, e_so4j
e_no3i, e_no3j, e_orgi, e_orgj, e_eci, e_ecj, e_so4c, e_no3c, e_orgc, e_ecc
}
\examples{
\dontrun{
# Do not run
}
}
\seealso{
\code{\link{emis_post}} \code{\link{emis}}
}
