% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_grid.R
\name{make_grid}
\alias{make_grid}
\title{Creates rectangular grid for emission allocation}
\usage{
make_grid(spobj, width, height, polygon = T)
}
\arguments{
\item{spobj}{A spatial object of class sp}

\item{width}{Width of grid cell, units according sr}

\item{height}{Height of grid cell, units according sr}

\item{polygon}{whe TRUE return a polygon grid, when FALSE a SpatialGridDataFrame}
}
\value{
A 'SpatialPolygonsDataFrame' or a 'SpatialGridDataFrame'
}
\description{
\code{make_grid} creates a SpatialGridDataFrame. The spatial
reference is taken from the spatial object.
}
\examples{
\dontrun{
#do not run
data(net)
grid <- make_grid(net, width = 0.5/102.47, height = 0.5/102.47) #500 mts
spplot(net, scales=list(draw=T),
sp.layout = list("sp.polygons", grid, pch = 16, cex = 2, col = "black"))
}
}
