% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netspeed.R
\name{netspeed}
\alias{netspeed}
\title{Calculate speeds of traffic network}
\usage{
netspeed(q = 1, ps, ffs, cap, lkm, alpha = 0.15, beta = 4,
  scheme = FALSE, distance = "km", time = "h")
}
\arguments{
\item{q}{Data-frame of traffic flow to each hour (veh/h)}

\item{ps}{Peak speed (km/h)}

\item{ffs}{Free flow speed (km/h)}

\item{cap}{Capacity of link (veh/h)}

\item{lkm}{Distance of link (km)}

\item{alpha}{Parameter of BPR curves}

\item{beta}{Parameter of BPR curves}

\item{scheme}{Logical to create a Speed data-frame with 24 hours and a
default  profile: ffs at 00:00-06:00, average speed at 06:00-07:00, ps
at 07:00-10:00, average speed between 10:0-17:00, ps at 17:00-20:00,
average speed at 20:00-22:00 and ffs at 22:00-00:00}

\item{distance}{Character specifying the units for distance. Default is "km"}

\item{time}{Character specifying the units for time Default is "h"}
}
\value{
dataframe or list of speeds with units
}
\description{
Creates a dataframe of speeds fir diferent hours and each link based on
morning rush traffic data
}
\examples{
\dontrun{
# Do not run
data(net)
data(pc_profile)
pc_week <- temp_fact(net$ldv+net$hdv, pc_profile)
df <- netspeed(pc_week, net$ps, net$ffs, net$capacity, net$lkm)
class(df)
plot(df) #plot of the average speed at each hour, +- sd
df <- netspeed(ps = net$ps, ffs = net$ffs, scheme = T)
class(df)
plot(df) #plot of the average speed at each hour, +- sd
}
}
