% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/running_losses.R
\name{running_losses}
\alias{running_losses}
\title{Estimation of average running losses evaporative emissions}
\usage{
running_losses(x, carb, p, erhotc, erwarmc, erhotfi)
}
\arguments{
\item{x}{Mean number of trips per vehicle per day}

\item{carb}{fraction of gasoline vehicles with carburator or fuel return system}

\item{p}{Fraction of trips finished with hot engine}

\item{erhotc}{average daily running losses evaporative factor for vehicles with
carburator or fuel return system}

\item{erwarmc}{average daily cold and warm running losses evaporative factor
for vehicles with carburator or fuel return system}

\item{erhotfi}{average daily hot running losses evaporative factor
for vehicles with fuel injection and returnless fuel systems}
}
\value{
numeric vector of emission estimation in grams
}
\description{
Estimation of evaporative emissions from EMEP/EEA emisison
guidelines
}
\examples{
\dontrun{
# Do not run
ev <- running_losses(x = 1:10, carb = 0, p = 1, erhot = 1, erwarmc =1,
erhotfi = 1)
}
}
\references{
Mellios G and Ntziachristos 2016. Gasoline evaporation. In:
EEA, EMEP. EEA air pollutant emission inventory guidebook-2009. European
Environment Agency, Copenhagen, 2009
}
