% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{write_file}
\alias{write_file}
\alias{write_file,ScriptOutput-method}
\title{Write file method}
\usage{
write_file(object, filepath, append = FALSE,
  encoding = getOption("encoding"), ...)

\S4method{write_file}{ScriptOutput}(object, filepath = "dmscript",
  append = FALSE, encoding = getOption("encoding"), ...)
}
\arguments{
\item{object}{Object to be written as a \code{\link[=ScriptOutput-class]{ScriptOutput}} object.}

\item{filepath}{Where to write the file. No need to add the extension, it will be put following the language of ScriptOutput. If an extension is given, then it will be used}

\item{append}{Append Append the file. \code{FALSE} by default.}

\item{encoding}{Character encoding to use. Use the default encoding if not specified.}

\item{...}{other options for specific methods}
}
\value{
Return invisibly the file path of the new file
}
\description{
Write a file for the specified object
}
\details{
If the object is a \code{\link[=ScriptOutput-class]{ScriptOutput}} object, it will write a script skeleton file .
}
\section{Methods (by class)}{
\itemize{
\item \code{ScriptOutput}: 
}}
\note{
Will be extended to others \pkg{vartors} objects in future releases. I don't use the \code{\link{write}} function because it is not a S3 or a S4 method and it's hard to promote in a good way.
}
\examples{
# Import a data.frame containing the description of the variables
# Show the description of the variable
sample_descvar

# Create the script skeleton simply with create_script()
script_skeleton <- create_script(sample_descvar)
# watch the result
script_skeleton
# Could be written in a file with the write() method
\dontrun{
write_file(script_skeleton)
}
}
\author{
Joris Muller
}
\seealso{
\code{\link{ScriptOutput-class}}
}
\keyword{main}

