% Generated by roxygen2 (4.0.1): do not edit by hand
\name{import_template}
\alias{import_template}
\title{Import a script template}
\usage{
import_template(path, builtin, language = "R", idiom = "en",
  encoding = "UTF-8")
}
\arguments{
\item{path}{Path to the template file}

\item{builtin}{The name of a built-in template. See details for available built-in template. Override \code{language} and \code{idiom} parameters if given.}

\item{language}{The name of one language of the built-in template, could be \code{en} or \code{fr}. If a path or a built-in is provided, this argument is ignored.}

\item{idiom}{The idiom of the built-in template, could be \code{en} or \code{fr}. If a path or a built-in is provided, this argument is ignored.}

\item{encoding}{Encoding of the script template. Should be "ASCII", "latin-1" or "UTF-8" (default value)}
}
\value{
Return a ScriptTemplate object.
}
\description{
Import a script template and transform it as an \code{\link{ScriptTemplate-class}}
object.
}
\details{
Actually, built-in templates are : \Sexpr{library(vartors);paste0(list_templates(), collapse = ", ")}
}
\examples{
# import the default built-in template
import_template()

# import a specific built-in template
import_template(builtin = "anothertemplate.R")
}
\author{
Joris Muller
}
\seealso{
\code{\link{ScriptTemplate-class}}, \code{\link{script_template}}
}
\keyword{main}
\keyword{template}

