% Generated by roxygen2 (4.0.1): do not edit by hand
\name{descvars_skeleton}
\alias{descvars_skeleton}
\title{Skeleton of a definition of variables table}
\usage{
descvars_skeleton(database, factor_detect = 6)
}
\arguments{
\item{database}{A data.frame with the data imported for example with \code{read.csv} or \code{read.xslx}.}

\item{factor_detect}{An integer. If the number of unique value in a variable is below this threshold, then it will be considered as a factor}
}
\value{
Return a \code{data.frame}. This \code{data.frame} could be used as a skeleton of descvar, for example exporting it in a file with \code{write.csv} or \code{write.xlsx}
}
\description{
Create a \emph{\link[=variable_definition_table]{definition of variables table}} skeleton in a data.frame from a database. Basically, this function gets the header of the database, puts it in the column "originalname", gets the type and put them in "type", adds column "spreadsheet column letter" and all the others columns to have a \emph{\link[=variable_definition_table]{definition of variables table}}.
}
\examples{
# Import a database
data(example_df)
head(example_df)

# Create a skeleton of DatabaseDef from this database
descvars_sk <- descvars_skeleton(example_df)
descvars_sk[,1:10]

# This skeleton could be written on the disk in csv
# to be completed later in a spreadsheet sofware
\dontrun{
write.csv(descvars_sk, file="Variables_description.csv")
}
# or in Excel
\dontrun{
libary(openxslx)
write.xlsx(descvars_sk, file="Variables_description.xlsx")
}
}
\author{
Joris Muller
}

