% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraintsFn.R
\name{objFunction}
\alias{objFunction}
\alias{gradObjFunction}
\alias{symMatrixFromVect}
\alias{ineqCstr}
\alias{jacobianIneqCstr}
\alias{eqCstr}
\alias{jacobianEqCstr}
\title{Internal functions for constrained minimization}
\usage{
objFunction(x, cst)

gradObjFunction(x, cst)

symMatrixFromVect(x)

ineqCstr(x, cst)

jacobianIneqCstr(x, cst)

eqCstr(x, cst)

jacobianEqCstr(x, cst)
}
\arguments{
\item{x}{A vector}

\item{cst}{A list of constants to be passed to the optimisation function}
}
\value{
value of the objective function, its gradient, and the set of inequality and equality constraints
}
\description{
Groups of functions used for the constrained minimization problem arising in the computation of the
likelihood ratio test statistics.
}
\section{Functions}{
\itemize{
\item \code{objFunction()}: objective function to be optimized

\item \code{gradObjFunction()}: gradient of the objective function

\item \code{symMatrixFromVect()}: function creating a symmetric matrix from its unique elements stored in a vector

\item \code{ineqCstr()}: set of inequality constraints

\item \code{jacobianIneqCstr()}: jacobian of the inequality constraints

\item \code{eqCstr()}: set of equality constraints

\item \code{jacobianEqCstr()}: jacobian of the inequality constraints

}}
