% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/first_differences.R
\name{trend}
\alias{trend}
\title{Specifying the transformation for dealing with trended series}
\usage{
trend(type = "additive", n = -1, transform_features = FALSE)
}
\arguments{
\item{type}{A character indicating the type of preprocessing applied to the
time series. Possible values are: \code{"none"}, \code{"additive"}, \code{"multiplicative"}
and \code{"differences"}.}

\item{n}{An integer specifying the order of first differences to be applied.
If the default (-1) is used, the order of first differences needed by the
time series will be estimated by the \code{\link[forecast:ndiffs]{forecast::ndiffs()}} function. This
parameter is only meant when the \code{type} parameter is \code{"differences"}.}

\item{transform_features}{A logical value indicating whether the training
features are also transformed with the additive or multiplicative
transformation.}
}
\value{
A list with the selected options
}
\description{
This function is used to specify the preprocessing associated with the trend
of a time series.
}
\examples{
trend("none")            # no preprocessing
trend("additive")        # additive preprocessing
trend("differences", 1)  # order 1 first differences
trend("differences", -1) # order of first differences automatically estimated
}
