% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_default_option}
\alias{umx_default_option}
\alias{umx_match.arg}
\title{Select first item in list of options, while being flexible about choices.}
\usage{
umx_default_option(x, option_list, check = TRUE)
}
\arguments{
\item{x}{the value chosen (may be the default option list)}

\item{option_list}{A vector of valid options}

\item{check}{Whether to check that single items are in the list. Set false to accept abbreviations (defaults to TRUE)}
}
\value{
- one validated option
}
\description{
Like a smart version of \code{\link{match.arg}}: Handles selecting parameter options when default is a list.
Unlike  x = \code{\link{match.arg}}(x) this allows items not in the list.
}
\examples{
option_list = c("default", "par.observed", "empirical")
umx_default_option("par.observed", option_list)

# An example of checking a bad item and stopping
\dontrun{
umx_default_option("bad", option_list)
}
umx_default_option("allow me", option_list, check = FALSE)
umx_default_option(option_list, option_list)
option_list = c(NULL, "par.observed", "empirical")
 # fails with NULL!!!!!
umx_default_option(option_list, option_list)
option_list = c(NA, "par.observed", "empirical")
umx_default_option(option_list, option_list) # use NA instead
option_list = c(TRUE, FALSE, NA)
umx_default_option(option_list, option_list) # works with non character
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{match.arg}}

Other Get and set: \code{\link{umx_get_checkpoint}},
  \code{\link{umx_get_options}},
  \code{\link{umx_set_auto_plot}},
  \code{\link{umx_set_auto_run}},
  \code{\link{umx_set_checkpoint}},
  \code{\link{umx_set_condensed_slots}},
  \code{\link{umx_set_cores}},
  \code{\link{umx_set_optimizer}},
  \code{\link{umx_set_plot_file_suffix}},
  \code{\link{umx_set_plot_format}},
  \code{\link{umx_set_table_format}}, \code{\link{umx}}
}
