% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nice}
\alias{nice}
\title{V4-V5 16S rRNA gene amplicons, clean OTU table (N-ICE, 2015)}
\format{
\subsection{\code{nice}}{

A data frame with 524 rows and 17 columns:
\describe{
\item{ERR2044662,
ERR2044663,
ERR2044664,
ERR2044665,
ERR2044666,
ERR2044667,
ERR2044668,
ERR2044669 and
ERR2044670}{Sample ID}
\item{OTU}{OTU ID}
\item{Domain}{Domain level classification of OTU}
\item{Phylum}{Phylum level classification of OTU}
\item{Class}{Class level classification of OTU}
\item{Order}{Order level classification of OTU}
\item{Family}{Family level classification of OTU}
\item{Genus}{Genus level classification of OTU}
\item{Species}{Species level classification of OTU}
...
}
}
}
\source{
\url{https://www.ebi.ac.uk/metagenomics/studies/MGYS00001922#analysis}
}
\usage{
nice
}
\description{
Table in "wide" format with abundance and taxonomic classification of each OTU.
}
\details{
This OTU table was cleaned so that it only includes samples from 16S rRNA amplicon sequencing
and no eukaryotes (similarly to Pascoal et al., 2022). Additionally, we added a column with a ID for each OTU.

For details on raw data, see \link{nice_raw}
}
\references{
\itemize{
\item Pascoal, F., Costa, R., Assmy, P., Duarte, P., & Magalhães, C. (2022). Exploration of the Types of Rarity in the Arctic Ocean from the Perspective of Multiple Methodologies. Microbial Ecology, 84(1), 59–72. https://doi.org/10.1007/s00248-021-01821-9
}
}
\seealso{
\code{\link[=nice_tidy]{nice_tidy()}}, \link{nice_raw}, \link{nice_env}
}
\keyword{datasets}
