% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_aug_shrink.R
\name{ts_aug_shrink}
\alias{ts_aug_shrink}
\title{Augmentation by shrink}
\usage{
ts_aug_shrink(scale_factor = 0.8)
}
\arguments{
\item{scale_factor}{for shrink}
}
\value{
a \code{ts_aug_shrink} object.
}
\description{
Time series data augmentation is a technique used to increase the size and diversity of a time series dataset by creating new instances of the original data through transformations or modifications. The goal is to improve the performance of machine learning models trained on time series data by reducing overfitting and improving generalization.
stretch does data augmentation by decreasing the volatility of the time series.
}
\examples{
library(daltoolbox)
data(sin_data)

#convert to sliding windows
xw <- ts_data(sin_data$y, 10)

#data augmentation using flip
augment <- ts_aug_shrink()
augment <- fit(augment, xw)
xa <- transform(augment, xw)
ts_head(xa)
}
