% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spread_paths.R
\name{spread_paths}
\alias{spread_paths}
\title{Spread the information in dose_finding_paths object to a wide data.frame format.}
\usage{
spread_paths(df = NULL, dose_finding_paths = NULL, max_depth = NULL)
}
\arguments{
\item{df}{Optional \code{data.frame} like that returned by
as_tibble(dose_finding_paths). Columns .depth, .node, .parent are required.
All other columns are spread with a suffix reflecting depth.}

\item{dose_finding_paths}{Optional instance of dose_finding_paths. Required
if `df` is null.}

\item{max_depth}{integer, maximum depth of paths to traverse.}
}
\value{
A data.frame
}
\description{
Spread the information in dose_finding_paths object to a wide data.frame format.
}
\examples{
\dontrun{
target <- 0.25
skeleton <- c(0.05, 0.15, 0.25, 0.4, 0.6)
paths <- crm_dtps(skeleton = skeleton, target = target, model = 'empiric',
                  cohort_sizes = c(1, 1), next_dose = 3, beta_sd = 1)
spread_paths(dose_finding_paths = paths)

df <- as_tibble(paths)
spread_paths(df)
spread_paths(df \%>\% select(-fit, -parent_fit, -dose_index))
}
}
