% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulationFunctions.R
\name{simulTrajec}
\alias{simulTrajec}
\title{Simulate trajectories and save as png files.}
\usage{
simulTrajec(nframes = 20, nIndividuals = 10, h = 0.02, rho = 0,
  domain = "square", correctBoundary = TRUE,
  sizes = stats::runif(nIndividuals) * 0.012 + 0.01, staticNoise = FALSE,
  movingNoise = FALSE, name = "trajectory", parsMoving = list(density =
  10, duration = 10, size = 1, speed = 10, colRange = c(0, 1)),
  parsStatic = list(density = 10, blur = TRUE, blurCoef = 0.025, sizes =
  NULL), width = 480, height = NULL)
}
\arguments{
\item{nframes}{Number of time frames(steps).}

\item{nIndividuals}{Number of individual trajectories.}

\item{h}{Displacement speed in pixels.}

\item{rho}{Correlation parameter for angle of displacement.}

\item{domain}{One of \code{"square"} or \code{"circle"}, imposing a [0-1,0-1] rectangle
domain, or a circlular domain of radius 1, respectively.
correct boundary ensure individual trajectories do not cross the domain}

\item{correctBoundary}{Logical. \code{TRUE} to make sure that individuals 
cannot leave the image.}

\item{sizes}{Vector of sizes for each simulated particle of length
nIndividuals.}

\item{staticNoise}{Logical. If \code{TRUE}, static noise is added.}

\item{movingNoise}{Logical. If \code{TRUE}, moving noise is added.}

\item{name}{Stem of the filename.}

\item{parsMoving}{List of parameters used to generate moving noise
these include the density of noise particles (\code{density}), their duration
(in n frames; \code{duration}), their size (\code{size=1}), 
their speed (\code{speed=10}) and the range or colors they are randomly drawn from
(\code{colRange=c(0,1)}).}

\item{parsStatic}{List of parameters used to generate static noise.
These include the density (per image) of noise particles (\code{density}), 
whether spots 
look blurry (\code{blur=TRUE} or \code{blur=FALSE}), a blurring coefficient
(\code{blurCoef=0.025}), and the size of the spots (with \code{sizes}).}

\item{width}{of created png image. By default 480.}

\item{height}{of create png image. If \code{NULL}, \code{width} is used.}
}
\description{
\code{simulTrajec} simulates movement trajectories within a 
are saved as png files.
}
\examples{
simulTrajec(nframes=30,h=0.01,rho=0.9)
}
\author{
Caspar A. Hallmann, Marjolein Bruijning & Marco D. Visser
}
