% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_rot90}
\alias{torch_rot90}
\title{Rot90}
\usage{
torch_rot90(self, k = 1L, dims = c(0, 1))
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{k}{(int) number of times to rotate}

\item{dims}{(a list or tuple) axis to rotate}
}
\description{
Rot90
}
\section{rot90(input, k, dims) -> Tensor }{


Rotate a n-D tensor by 90 degrees in the plane specified by dims axis.
Rotation direction is from the first towards the second axis if k > 0, and from the second towards the first for k < 0.
}

\examples{
if (torch_is_installed()) {

x <- torch_arange(1, 4)$view(c(2, 2))
x
torch_rot90(x, 1, c(1, 2))
x <- torch_arange(1, 8)$view(c(2, 2, 2))
x
torch_rot90(x, 1, c(1, 2))
}
}
