% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_matrix_exp}
\alias{torch_matrix_exp}
\title{Matrix_exp}
\usage{
torch_matrix_exp(self)
}
\arguments{
\item{self}{(Tensor) the input tensor.}
}
\description{
Matrix_exp
}
\section{matrix_power(input) -> Tensor }{


Returns the matrix exponential. Supports batched input.
For a matrix \code{A}, the matrix exponential is defined as

\deqn{
    \exp^A = \sum_{k=0}^\infty A^k / k!.
}

The implementation is based on:
Bader, P.; Blanes, S.; Casas, F.
Computing the Matrix Exponential with an Optimized Taylor Polynomial Approximation.
Mathematics 2019, 7, 1174.
}

\examples{
if (torch_is_installed()) {

a <- torch_randn(c(2, 2, 2))
a[1, , ] <- torch_eye(2, 2)
a[2, , ] <- 2 * torch_eye(2, 2)
a
torch_matrix_exp(a)

x <- torch_tensor(rbind(c(0, pi/3), c(-pi/3, 0)))
x$matrix_exp() # should be [[cos(pi/3), sin(pi/3)], [-sin(pi/3), cos(pi/3)]]
}
}
