% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/wrapers.R
\name{torch_movedim}
\alias{torch_movedim}
\title{Movedim}
\usage{
torch_movedim(self, source, destination)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{source}{(int or tuple of ints) Original positions of the dims to move. These must be unique.}

\item{destination}{(int or tuple of ints) Destination positions for each of the original dims. These must also be unique.}
}
\description{
Movedim
}
\section{movedim(input, source, destination) -> Tensor }{


Moves the dimension(s) of \code{input} at the position(s) in \code{source}
to the position(s) in \code{destination}.

Other dimensions of \code{input} that are not explicitly moved remain in
their original order and appear at the positions not specified in \code{destination}.
}

\examples{
if (torch_is_installed()) {

t <- torch_randn(c(3,2,1))
t
torch_movedim(t, 2, 1)$shape
torch_movedim(t, 2, 1)
torch_movedim(t, c(2, 3), c(1, 2))$shape
torch_movedim(t, c(2, 3), c(1, 2))
}
}
