% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ignite.R
\name{optim_ignite_adamw}
\alias{optim_ignite_adamw}
\title{LibTorch implementation of AdamW}
\usage{
optim_ignite_adamw(
  params,
  lr = 0.001,
  betas = c(0.9, 0.999),
  eps = 1e-08,
  weight_decay = 0.01,
  amsgrad = FALSE
)
}
\arguments{
\item{params}{(iterable): iterable of parameters to optimize or dicts defining
parameter groups}

\item{lr}{(float, optional): learning rate (default: 1e-3)}

\item{betas}{(\code{Tuple[float, float]}, optional): coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))}

\item{eps}{(float, optional): term added to the denominator to improve
numerical stability (default: 1e-8)}

\item{weight_decay}{(float, optional): weight decay (L2 penalty) (default: 0)}

\item{amsgrad}{(boolean, optional): whether to use the AMSGrad variant of this
algorithm from the paper \href{https://openreview.net/forum?id=ryQu7f-RZ}{On the Convergence of Adam and Beyond}
(default: FALSE)}
}
\description{
For further details regarding the algorithm we refer to
\href{https://arxiv.org/abs/1711.05101}{Decoupled Weight Decay Regularization}
}
\section{Fields and Methods}{

See \code{\link{OptimizerIgnite}}.
}

\examples{
if (torch_is_installed()) {
\dontrun{
optimizer <- optim_ignite_adamw(model$parameters(), lr = 0.1)
optimizer$zero_grad()
loss_fn(model(input), target)$backward()
optimizer$step()
}
}
}
