% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-data-dataloader.R
\name{dataloader}
\alias{dataloader}
\title{Data loader. Combines a dataset and a sampler, and provides
single- or multi-process iterators over the dataset.}
\usage{
dataloader(
  dataset,
  batch_size = 1,
  shuffle = FALSE,
  sampler = NULL,
  batch_sampler = NULL,
  num_workers = 0,
  collate_fn = NULL,
  pin_memory = FALSE,
  drop_last = FALSE,
  timeout = -1,
  worker_init_fn = NULL,
  worker_globals = NULL,
  worker_packages = NULL
)
}
\arguments{
\item{dataset}{(Dataset): dataset from which to load the data.}

\item{batch_size}{(int, optional): how many samples per batch to load
(default: \code{1}).}

\item{shuffle}{(bool, optional): set to \code{TRUE} to have the data reshuffled
at every epoch (default: \code{FALSE}).}

\item{sampler}{(Sampler, optional): defines the strategy to draw samples from
the dataset. If specified, \code{shuffle} must be False. Custom samplers can be
created with \code{\link[=sampler]{sampler()}}.}

\item{batch_sampler}{(Sampler, optional): like sampler, but returns a batch of
indices at a time. Mutually exclusive with \code{batch_size},
\code{shuffle}, \code{sampler}, and \code{drop_last}. Custom samplers can be created with
\code{\link[=sampler]{sampler()}}.}

\item{num_workers}{(int, optional): how many subprocesses to use for data
loading. 0 means that the data will be loaded in the main process.
(default: \code{0})}

\item{collate_fn}{(callable, optional): merges a list of samples to form a mini-batch.}

\item{pin_memory}{(bool, optional): If \code{TRUE}, the data loader will copy tensors
into CUDA pinned memory before returning them.  If your data elements
are a custom type, or your \code{collate_fn} returns a batch that is a custom type
see the example below.}

\item{drop_last}{(bool, optional): set to \code{TRUE} to drop the last incomplete batch,
if the dataset size is not divisible by the batch size. If \code{FALSE} and
the size of dataset is not divisible by the batch size, then the last batch
will be smaller. (default: \code{FALSE})}

\item{timeout}{(numeric, optional): if positive, the timeout value for collecting a batch
from workers. -1 means no timeout. (default: \code{-1})}

\item{worker_init_fn}{(callable, optional): If not \code{NULL}, this will be called on each
worker subprocess with the worker id (an int in \verb{[1, num_workers]}) as
input, after seeding and before data loading. (default: \code{NULL})}

\item{worker_globals}{(list or character vector, optional) only used when
\code{num_workers > 0}. If a character vector, then objects with those names are
copied from the global environment to the workers. If a named list, then
this list is copied and attached to the worker global environment. Notice
that the objects are copied only once at the worker initialization.}

\item{worker_packages}{(character vector, optional) Only used if \code{num_workers > 0}
optional character vector naming packages that should be loaded in
each worker.}
}
\description{
Data loader. Combines a dataset and a sampler, and provides
single- or multi-process iterators over the dataset.
}
\section{Parallel data loading}{


When using \code{num_workers > 0} data loading will happen in parallel for each
worker. Note that batches are taken in parallel and not observations.

The worker initialization  process happens in the following order:
\itemize{
\item \code{num_workers} R sessions are initialized.
}

Then in each worker we perform the following actions:
\itemize{
\item the \code{torch} library is loaded.
\item a random seed is set both using \code{set.seed()} and using \code{torch_manual_seed}.
\item packages passed to the \code{worker_packages} argument are loaded.
\item objects passed trough the \code{worker_globals} parameters are copied into the
global environment.
\item the \code{worker_init} function is ran with an \code{id} argument.
\item the dataset fetcher is copied to the worker.
}
}

\seealso{
\code{\link[=dataset]{dataset()}}, \code{\link[=sampler]{sampler()}}
}
