\name{prop.excess}
\alias{prop.excess}
\title{Fits Proportional excess hazards model}
\description{
Fits proportional excess hazards model.

The models are written using the survival modelling given in the 
survival package.
}
\usage{
prop.excess(formula=formula(data),data=sys.parent(),excess=1
,tol=0.0001,max.time=NULL,n.sim=1000,alpha=1,frac=1)
}
\arguments{
\item{formula}{
a formula object, with the response on the left of a `~' operator, and
the terms on the right.  The response must be a survival object as
returned by the `Surv' function.
}
\item{data}{a data.frame with the variables.
}
\item{excess}{specifies for which of the subjects the excess term is
present. Default is that the term is present for all subjects.
}
\item{tol}{tolerance for numerical procedure.}
\item{max.time}{stopping considered time-period if different from 0. 
Estimates thus computed from [0,max.time] if max.time>0. Default is max of data.}
\item{n.sim}{number of simulations in re-sampling.}
\item{alpha}{ tuning paramter in Newton-Raphson procedure. Value smaller than 
   one may give more stable convergence.}
\item{frac}{number between 0 and 1. 
Is used in supremum test where observed jump times t1,
 ..., tk is replaced by t1, ..., tl with l=round(frac*k).}
}
\details{
The program assumes that there are no ties, and if such are present 
random noise is added to break the ties.
}
\value{Returns an object of type "prop.excess". With the following arguments:
\item{cum}{estimated cumulative regression functions. First column 
 contains the jump times, then follows  the estimated components of 
additive part of model and finally the excess cumulative baseline.
}
\item{var.cum}{robust pointwise variance estimates for estimated cumulatives.
}
\item{gamma}{estimate of parametric components of model.
}
\item{var.gamma}{robust variance estimate for gamma.
}
\item{pval}{p-value of  Kolmogorov-Smirnov test (variance weighted)
   for excess baseline and  Aalen terms, H: B(t)=0.
}
\item{pval.HW}{p-value of supremum test (corresponding to Hall-Wellner band)
for excess baseline and  Aalen terms, H: B(t)=0. Reported in summary.
}
\item{pval.CM}{p-value of Cramer von Mises test for excess baseline and Aalen 
 terms, H: B(t)=0.
}
\item{quant}{95 percent quantile in distribution of resampled 
 Kolmogorov-Smirnov test statistics for excess baseline and
  Aalen terms. Used to construct 95 percent simulation band. 
}
\item{quant95HW}{95 percent quantile in distribution of resampled 
 supremum test statistics corresponding to Hall-Wellner band for excess baseline and
  Aalen terms. Used to construct 95 percent Hall-Wellner band. 
}
\item{simScoreProp}{observed scoreprocess and 50 resampled scoreprocesses (under model).
List with 51 elements.
}
}
\references{
Martinussen and Scheike, Dynamic Regression Models for Survival Data,
Springer Verlag (2006).
}
\author{Torben Martinussen}
\examples{
\donttest{
data(melanoma)
lt<-log(melanoma$thick)          # log-thickness 
excess<-(melanoma$thick>=210)    # excess risk for thick tumors

# Fits Proportional Excess hazards model 
fit<-prop.excess(Surv(days/365,status==1)~sex+ulc+cox(sex)+
                 cox(ulc)+cox(lt),melanoma,excess=excess,n.sim=100)
summary(fit)
par(mfrow=c(2,3))
plot(fit)
}
}
\keyword{survival}
