% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_corrosion.R
\name{calculate_corrosion_once}
\alias{calculate_corrosion_once}
\title{Apply `calculate_corrosion` to a dataframe and create new columns with up to 6 corrosion indices}
\usage{
calculate_corrosion_once(
  df,
  input_water = "defined_water",
  index = c("aggressive", "ryznar", "langelier", "ccpp", "larsonskold", "csmr"),
  form = "calcite"
)
}
\arguments{
\item{df}{a data frame containing a water class column, created using \code{\link{define_water}}}

\item{input_water}{name of the column of water class data to be used as the input. Default is "defined_water".}

\item{index}{The indices to be calculated.
Default calculates all six indices: "aggressive", "ryznar", "langelier", "ccpp", "larsonskold", "csmr".
CCPP may not be able to be calculated sometimes, so it may be advantageous to leave this out of the function to avoid errors}

\item{form}{Form of calcium carbonate mineral to use for modelling solubility: "calcite" (default), "aragonite", or "vaterite"}
}
\value{
A data frame containing specified corrosion and scaling indices.
}
\description{
This function allows \code{\link{calculate_corrosion}} to be added to a piped data frame.
Up to six additional columns will be added to the dataframe depending on what corrosion/scaling
indices are selected: Aggressive index (AI), Ryznar index (RI), Langelier saturation index (LSI),
Larson-Skold index (LI), chloride-to-sulfate mass ratio (CSMR) & calcium carbonate precipitation potential (CCPP).
}
\details{
The data input comes from a `water` class column, initialized in \code{\link{define_water}} or \code{\link{balance_ions}}.

For large datasets, using `fn_once` or `fn_chain` may take many minutes to run. These types of functions use the furrr package
for the option to use parallel processing and speed things up. To initialize parallel processing, use
`plan(multisession)` or `plan(multicore)` (depending on your operating system) prior to your piped code with the
`fn_once` or `fn_chain` functions. Note, parallel processing is best used when your code block takes more than a minute to run,
shorter run times will not benefit from parallel processing.
}
\examples{

library(purrr)
library(furrr)
library(tidyr)
library(dplyr)

example_df <- water_df \%>\%
  slice_head(n = 2) \%>\% # used to make example run faster
  define_water_chain() \%>\%
  calculate_corrosion_once()

example_df <- water_df \%>\%
  slice_head(n = 2) \%>\% # used to make example run faster
  define_water_chain() \%>\%
  calculate_corrosion_once(index = c("aggressive", "ccpp"))

\donttest{
# Initialize parallel processing
plan(multisession, workers = 2) # Remove the workers argument to use all available compute
example_df <- water_df \%>\%
  define_water_chain() \%>\%
  calculate_corrosion_once(index = c("aggressive", "ccpp"))

# Optional: explicitly close multisession processing
plan(sequential)
}

}
\seealso{
\code{\link{calculate_corrosion}}
}
