% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biofilter_toc.R
\name{biofilter_toc_chain}
\alias{biofilter_toc_chain}
\title{Apply `biofilter_toc` within a dataframe and output a column of `water` class to be chained to other tidywater functions}
\usage{
biofilter_toc_chain(
  df,
  input_water = "defined_water",
  output_water = "biofiltered_water",
  ebct = 0,
  ozonated = TRUE
)
}
\arguments{
\item{df}{a data frame containing a water class column, which has already been computed using
\code{\link{define_water_chain}}. The df may include a column indicating the EBCT or whether the water is ozonated.
and a column named for the set of coefficients to use.}

\item{input_water}{name of the column of Water class data to be used as the input for this function. Default is "defined_water".}

\item{output_water}{name of the output column storing updated parameters with the class, Water. Default is "biofiltered_water".}

\item{ebct}{The empty bed contact time (min) used for the biofilter}

\item{ozonated}{Logical; TRUE if the water is ozonated (default), FALSE otherwise}
}
\value{
A data frame containing a water class column with updated DOC, TOC, and UV254 water slots.
}
\description{
This function allows \code{\link{biofilter_toc}} to be added to a piped data frame.
Its output is a `water` class, and can therefore be used with "downstream" tidywater functions.
TOC, DOC, and UV254 water slots will be updated based on input EBCT and whether the water is ozonated.
}
\details{
The data input comes from a `water` class column, as initialized in \code{\link{define_water_chain}}.

If the input data frame has column(s) named "ebct" or "ozonated", the function uses those as arguments. Note:
The function can use either a column or the direct function arguments, not both.

 For large datasets, using `fn_once` or `fn_chain` may take many minutes to run. These types of functions use the furrr package
 for the option to use parallel processing and speed things up. To initialize parallel processing, use
 `plan(multisession)` or `plan(multicore)` (depending on your operating system) prior to your piped code with the
 `fn_once` or `fn_chain` functions. Note, parallel processing is best used when your code block takes more than a minute to run,
 shorter run times will not benefit from parallel processing.
}
\examples{

library(purrr)
library(furrr)
library(tidyr)
library(dplyr)

example_df <- water_df \%>\%
  define_water_chain() \%>\%
  biofilter_toc_chain(input_water = "defined_water", ebct = 10, ozonated = FALSE)

example_df <- water_df \%>\%
  define_water_chain() \%>\%
  mutate(
    ebct = c(10, 10, 10, 15, 15, 15, 20, 20, 20, 25, 25, 25),
    ozonated = c(rep(TRUE, 6), rep(FALSE, 6))
  ) \%>\%
  biofilter_toc_chain(input_water = "defined_water")

# Initialize parallel processing
plan(multisession, workers = 2) # Remove the workers argument to use all available compute
example_df <- water_df \%>\%
  define_water_chain() \%>\%
  biofilter_toc_chain(input_water = "defined_water", ebct = c(10, 20))

# Optional: explicitly close multisession processing
plan(sequential)

}
\seealso{
\code{\link{biofilter_toc}}
}
