% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_available.R
\name{tt_print}
\alias{tt_print}
\alias{print.tt_dataset_table}
\alias{print.tt_dataset_table_list}
\title{Printing Utilities for Listing Available Datasets}
\usage{
\method{print}{tt_dataset_table}(x, ..., is_interactive = interactive())

\method{print}{tt_dataset_table_list}(x, ..., is_interactive = interactive())
}
\arguments{
\item{x}{an object used to select a method.}

\item{...}{further arguments passed to or from other methods.}

\item{is_interactive}{Whether the function is being used interactively.}
}
\value{
\code{x}, invisibly
}
\description{
printing utilities for showing the available datasets for a specific year or
all time
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# check to make sure there are requests still available
if (rate_limit_check(quiet = TRUE) > 30) {
  available_datasets_2018 <- tt_datasets(2018)
  print(available_datasets_2018)

  all_available_datasets <- tt_available()
  print(all_available_datasets)
}
\dontshow{\}) # examplesIf}
}
