% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncount.R
\name{uncount_dt}
\alias{uncount_dt}
\title{"Uncount" a data frame}
\usage{
uncount_dt(.data, wt, .remove = TRUE)
}
\arguments{
\item{.data}{A data.frame}

\item{wt}{A vector of weights.}

\item{.remove}{Should the column for \code{weights} be removed?
Default uses \code{TRUE}.}
}
\description{
Duplicating rows according to a weighting variable.
 This is the opposite operation of `count_dt`.
 Analogous to `tidyr::uncount`.
}
\examples{

df <- data.table(x = c("a", "b"), n = c(1, 2))
uncount_dt(df, n)
uncount_dt(df,n,FALSE)
}
\seealso{
\code{\link[dplyr]{count}}, \code{\link[tidyr]{uncount}}
}
