% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R, R/pkg-stats.R
\name{HQC}
\alias{HQC}
\alias{HQC.default}
\alias{HQC.logLik}
\title{Hannan–Quinn information criterion}
\usage{
HQC(object, ...)

\method{HQC}{default}(object, ...)

\method{HQC}{logLik}(object, ...)
}
\arguments{
\item{object}{any object from which a log-likelihood value, or a
   contribution to a log-likelihood value, can be extracted.}

\item{...}{some methods for this generic function require additional
   arguments.}
}
\description{
Hannan–Quinn information criterion
}
\details{
Computes the Hannan-Quinn information criterion for a model \eqn{M}
\deqn{
  HQC(\tau, M(y|\hat{\theta}_{\tau})) = 2k \cdot \ln{\ln{n}} - 2 \cdot L_M(y|\hat{\theta}_\tau) \,,
}
where \eqn{k} is the number of parameters and \eqn{n} is the number of observations.
}
\examples{
# Compute the HQC
HQC(fit_meanvar(CET, tau = NULL))

HQC(fit_meanshift_norm_ar1(CET, tau = c(42, 330)))
HQC(fit_trendshift(CET, tau = c(42, 81, 330)))
}
\seealso{
\code{\link[stats:AIC]{stats::BIC()}}, \code{\link[stats:AIC]{stats::AIC()}}

Other penalty-functions: 
\code{\link{BMDL}()},
\code{\link{MBIC}()},
\code{\link{MDL}()},
\code{\link{SIC}()}
}
\concept{penalty-functions}
